/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

import { html } from "lit";
import "mail/components/inappnotifications/content/in-app-notification-container.mjs";
import "mail/themes/shared/mail/icons.css";

export default {
  title: "Widgets/In App Notifications/Container",
  component: "in-app-notification-container",
  tags: ["autodocs"],
  argTypes: {
    type: {
      options: ["donation", "message", "blog", "security"],
    },
  },
};

const template = ({ cta, description, heading, url, type }) => html`
  <template
    id="inAppNotificationCloseButtonTemplate"
    xmlns="http://www.w3.org/1999/xhtml"
  >
    <img src="" data-l10n-id="in-app-notification-close-image" />
  </template>

  <template
    id="inAppNotificationContainerTemplate"
    xmlns="http://www.w3.org/1999/xhtml"
  >
    <div class="in-app-notification-container" tabindex="0">
      <button is="in-app-notification-close-button"></button>
      <img src="" alt="" class="icon" />
      <div class="in-app-notification-content">
        <h1 class="in-app-notification-heading"></h1>
        <div class="in-app-notification-description-wrapper">
          <p class="in-app-notification-description"></p>
        </div>
        <a is="in-app-notification-button">
          <span class="in-app-notification-cta"></span>
        </a>
      </div>
    </div>
    <span
      class="in-app-notification-instructions"
      data-l10n-id="in-app-notification-instructions"
    ></span>
  </template>
  <in-app-notification-container
    cta="${cta}"
    description="${description}"
    heading="${heading}"
    url="${url}"
    type="${type}"
  ></in-app-notification-container>
`;

export const InAppNotificationContainer = template.bind({});

InAppNotificationContainer.args = {
  cta: "Click Here",
  description: "Give us your money pretty please!",
  heading: "We really need your money...",
  url: "https://example.com/money",
  type: "donation",
};
