/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

"use strict";

const { getIdealDialogPosition } = ChromeUtils.importESModule(
  "chrome://messenger/content/dialog-position.mjs"
);

const tests = [
  {
    label: "Horizontal",
    message: "Excess space inline-end",
    trigger: {
      height: 100,
      width: 100,
      left: 400,
      top: 400,
      bottom: 500,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `400px`,
    },
  },
  {
    label: "Horizontal",
    message: "Excess space inline-start",
    trigger: {
      height: 100,
      width: 100,
      left: 600,
      top: 400,
      bottom: 500,
      right: 700,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `488px`,
      y: `400px`,
    },
  },
  {
    label: "Horizontal",
    message: "Excess space equal",
    trigger: {
      height: 100,
      width: 100,
      left: 450,
      top: 450,
      bottom: 550,
      right: 550,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `338px`,
      y: `450px`,
    },
  },
  {
    label: "Horizontal",
    message: "Not enough start space",
    trigger: {
      height: 100,
      width: 100,
      left: 400,
      top: 400,
      bottom: 500,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 400,
      height: 100,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `400px`,
    },
  },
  {
    label: "Horizontal",
    message: "Not enough end space",
    trigger: {
      height: 100,
      width: 100,
      left: 600,
      top: 400,
      bottom: 500,
      right: 700,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 400,
      height: 100,
      margin: 12,
    },
    result: {
      x: `188px`,
      y: `400px`,
    },
  },
  {
    label: "Horizontal",
    message: "Narrow viewport",
    trigger: {
      height: 100,
      width: 100,
      left: 400,
      top: 400,
      bottom: 500,
      right: 500,
    },
    container: {
      height: 1000,
      width: 500,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 500,
    },
    dialog: {
      width: 400,
      height: 100,
      margin: 12,
    },
    result: {
      x: `50px`,
      y: `512px`,
    },
  },
  {
    label: "Horizontal",
    message: "Narrow viewport centered on trigger",
    trigger: {
      height: 100,
      width: 100,
      left: 250,
      top: 400,
      bottom: 500,
      right: 500,
    },
    container: {
      height: 1000,
      width: 600,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 600,
    },
    dialog: {
      width: 300,
      height: 100,
      margin: 12,
    },
    result: {
      x: `150px`,
      y: `512px`,
    },
  },
  {
    label: "Vertical: Has Horizontal Space",
    message: "Excess space inline-start",
    trigger: {
      height: 100,
      width: 100,
      left: 400,
      top: 400,
      bottom: 500,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `400px`,
    },
  },
  {
    label: "Vertical: Has Horizontal Space",
    message: "Excess space block-start",
    trigger: {
      height: 100,
      width: 100,
      left: 400,
      top: 700,
      bottom: 800,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `700px`,
    },
  },
  {
    label: "Vertical: Has Horizontal Space",
    message: "Excess space block end",
    trigger: {
      height: 100,
      width: 100,
      left: 400,
      top: 100,
      bottom: 200,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `100px`,
    },
  },
  {
    label: "Vertical: Has Horizontal Space",
    message: "Trigger above",
    trigger: {
      height: 100,
      width: 100,
      left: 400,
      top: 10,
      bottom: 110,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `12px`,
    },
  },
  {
    label: "Vertical: Has Horizontal Space",
    message: "Trigger below",
    trigger: {
      height: 100,
      width: 100,
      left: 400,
      top: 900,
      bottom: 1000,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `888px`,
    },
  },
  {
    label: "Vertical: Has Horizontal Space",
    message: "Trigger centered",
    trigger: {
      height: 100,
      width: 100,
      left: 400,
      top: 450,
      bottom: 550,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `450px`,
    },
  },
  {
    label: "Vertical: Lacks Horizontal Space",
    message: "Trigger bottom",
    trigger: {
      height: 100,
      width: 100,
      left: 50,
      top: 800,
      bottom: 900,
      right: 150,
    },
    container: {
      height: 1000,
      width: 200,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 200,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `50px`,
      y: `688px`,
    },
  },
  {
    label: "Vertical: Lacks Horizontal Space",
    message: "Trigger top",
    trigger: {
      height: 100,
      width: 100,
      left: 50,
      top: 200,
      bottom: 300,
      right: 150,
    },
    container: {
      height: 1000,
      width: 200,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 200,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `50px`,
      y: `312px`,
    },
  },
  {
    label: "Vertical: Lacks Horizontal Space",
    message: "Trigger centered",
    trigger: {
      height: 100,
      width: 100,
      left: 50,
      top: 450,
      bottom: 550,
      right: 150,
    },
    container: {
      height: 1000,
      width: 200,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 200,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `50px`,
      y: `562px`,
    },
  },
  {
    label: "Vertical: Lacks Horizontal Space",
    message: "Short viewport",
    trigger: {
      height: 100,
      width: 100,
      left: 50,
      top: 250,
      bottom: 350,
      right: 150,
    },
    container: {
      height: 500,
      width: 200,
      left: 0,
      top: 0,
      bottom: 500,
      right: 200,
    },
    dialog: {
      width: 100,
      height: 400,
      margin: 12,
    },
    result: {
      x: `50px`,
      y: `50px`,
    },
  },
  {
    label: "Overflow",
    message: "Inline start",
    trigger: {
      height: 100,
      width: 400,
      left: -100,
      top: 200,
      bottom: 300,
      right: 300,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `312px`,
      y: `200px`,
    },
  },
  {
    label: "Overflow",
    message: "Inline start full",
    trigger: {
      height: 100,
      width: 400,
      left: -500,
      top: 200,
      bottom: 300,
      right: -100,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `12px`,
      y: `200px`,
    },
  },
  {
    label: "Overflow",
    message: "Inline end",
    trigger: {
      height: 100,
      width: 400,
      left: 900,
      top: 200,
      bottom: 300,
      right: 1300,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `488px`,
      y: `200px`,
    },
  },
  {
    label: "Overflow",
    message: "Inline end full",
    trigger: {
      height: 100,
      width: 400,
      left: 1100,
      top: 200,
      bottom: 300,
      right: 1400,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `588px`,
      y: `200px`,
    },
  },
  {
    label: "Overflow",
    message: "Block start",
    trigger: {
      height: 400,
      width: 400,
      left: 100,
      top: -100,
      bottom: 300,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `12px`,
    },
  },
  {
    label: "Overflow",
    message: "Block start full",
    trigger: {
      height: 400,
      width: 400,
      left: 100,
      top: -500,
      bottom: -100,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `12px`,
    },
  },
  {
    label: "Overflow",
    message: "Block end",
    trigger: {
      height: 400,
      width: 400,
      left: 100,
      top: 900,
      bottom: 1300,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `588px`,
    },
  },
  {
    label: "Overflow",
    message: "Block end full",
    trigger: {
      height: 400,
      width: 400,
      left: 100,
      top: 1100,
      bottom: 1500,
      right: 500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 0,
      bottom: 1000,
      right: 1000,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `512px`,
      y: `588px`,
    },
  },
  {
    label: "Container Offset",
    message: "Inline start",
    trigger: {
      height: 100,
      width: 100,
      left: 200,
      top: 100,
      bottom: 200,
      right: 300,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 100,
      top: 0,
      bottom: 1000,
      right: 1100,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `312px`,
      y: `100px`,
    },
  },
  {
    label: "Container Offset",
    message: "Block start",
    trigger: {
      height: 100,
      width: 100,
      left: 100,
      top: 200,
      bottom: 300,
      right: 200,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 100,
      bottom: 900,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `212px`,
      y: `200px`,
    },
  },
  {
    label: "Container Offset: Inline: Overflow:",
    message: "Inline start",
    trigger: {
      height: 100,
      width: 100,
      left: 50,
      top: 100,
      bottom: 200,
      right: 150,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 100,
      top: 0,
      bottom: 1000,
      right: 1100,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `162px`,
      y: `100px`,
    },
  },
  {
    label: "Container Offset: Inline: Overflow:",
    message: "Inline start full",
    trigger: {
      height: 100,
      width: 100,
      left: -50,
      top: 100,
      bottom: 200,
      right: 50,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 100,
      top: 0,
      bottom: 1000,
      right: 1100,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `112px`,
      y: `100px`,
    },
  },
  {
    label: "Container Offset: Inline: Overflow:",
    message: "Inline end",
    trigger: {
      height: 100,
      width: 100,
      left: 1050,
      top: 100,
      bottom: 200,
      right: 1150,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 100,
      top: 0,
      bottom: 1000,
      right: 1100,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `638px`,
      y: `100px`,
    },
  },
  {
    label: "Container Offset: Inline: Overflow:",
    message: "Inline end full",
    trigger: {
      height: 100,
      width: 100,
      left: 1150,
      top: 100,
      bottom: 200,
      right: 1250,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 100,
      top: 0,
      bottom: 1000,
      right: 1100,
    },
    dialog: {
      width: 400,
      height: 400,
      margin: 12,
    },
    result: {
      x: `688px`,
      y: `100px`,
    },
  },
  {
    label: "Container Offset: Block: Overflow:",
    message: "Inline start",
    trigger: {
      height: 100,
      width: 100,
      left: -50,
      top: 200,
      bottom: 300,
      right: 50,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 100,
      bottom: 1100,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `62px`,
      y: `200px`,
    },
  },
  {
    label: "Container Offset: Block: Overflow:",
    message: "Inline start full",
    trigger: {
      height: 100,
      width: 100,
      left: -150,
      top: 200,
      bottom: 200,
      right: -500,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 100,
      bottom: 1100,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `12px`,
      y: `200px`,
    },
  },
  {
    label: "Container Offset: Block: Overflow:",
    message: "Inline end",
    trigger: {
      height: 100,
      width: 100,
      left: 100,
      top: 200,
      bottom: 300,
      right: 200,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 100,
      bottom: 1100,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `212px`,
      y: `200px`,
    },
  },
  {
    label: "Container Offset: Block: Overflow:",
    message: "Inline end full",
    trigger: {
      height: 100,
      width: 100,
      left: 100,
      top: -50,
      bottom: 50,
      right: 200,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 100,
      bottom: 1100,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `212px`,
      y: `112px`,
    },
  },
  {
    label: "Container Offset: Block: Overflow:",
    message: "Block end",
    trigger: {
      height: 100,
      width: 100,
      left: 100,
      top: 1050,
      bottom: 1150,
      right: 200,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 100,
      bottom: 1100,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `212px`,
      y: `988px`,
    },
  },
  {
    label: "Container Offset: Block: Overflow:",
    message: "Block end full",
    trigger: {
      height: 100,
      width: 100,
      left: 100,
      top: 1150,
      bottom: 1250,
      right: 200,
    },
    container: {
      height: 1000,
      width: 1000,
      left: 0,
      top: 100,
      bottom: 1100,
      right: 1000,
    },
    dialog: {
      width: 100,
      height: 100,
      margin: 12,
    },
    result: {
      x: `212px`,
      y: `988px`,
    },
  },
];

add_task(function test_dialogPosition() {
  for (const { trigger, container, message, label, dialog, result } of tests) {
    const position = getIdealDialogPosition({ trigger, container, dialog });

    Assert.equal(position.x, result.x, `${label} - ${message} x value`);
    Assert.equal(position.y, result.y, `${label} - ${message} y value`);
  }
});
