"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateDecimalSas = generateDecimalSas;
/*
Copyright 2018 - 2022 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/**
 * Implementation of decimal encoding of SAS as per:
 * https://spec.matrix.org/v1.4/client-server-api/#sas-method-decimal
 * @param sasBytes - the five bytes generated by HKDF
 * @returns the derived three numbers between 1000 and 9191 inclusive
 */
function generateDecimalSas(sasBytes) {
  /*
   *      +--------+--------+--------+--------+--------+
   *      | Byte 0 | Byte 1 | Byte 2 | Byte 3 | Byte 4 |
   *      +--------+--------+--------+--------+--------+
   * bits: 87654321 87654321 87654321 87654321 87654321
   *       \____________/\_____________/\____________/
   *         1st number    2nd number     3rd number
   */
  return [(sasBytes[0] << 5 | sasBytes[1] >> 3) + 1000, ((sasBytes[1] & 0x7) << 10 | sasBytes[2] << 2 | sasBytes[3] >> 6) + 1000, ((sasBytes[3] & 0x3f) << 7 | sasBytes[4] >> 1) + 1000];
}